#include "univ.h"

#include <Xol/Notice.h>
#include <Xol/OblongButt.h>
#include <Xol/ScrollingL.h>
#include <Xol/StaticText.h>
#include <Xol/ControlAre.h>

static Widget pick;
static Index pickindex;

void PickPopDownCB(w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	Pad *p;

	for (p = Sentinel.back; ISPAD(p); p = p->back)
		if (p->haswindow)
			XtVaSetValues(p->pane, XtNbusy, FALSE, NULL);
	XtDestroyWidget(w);
}

void PickSelectCB(w, p, call_data)
Widget w;
Pad *p;
XtPointer call_data;
{
	PickedPad(p, pickindex);
}

PickaPad(i)
Index i;
{

	Widget control;
	Widget w;
	char buffer[256];
	Pad *p;
	char *padtype;

	sprintf(buffer, "Select process window to %s", IndexToStr(i));
	pickindex = i;
	pick = XtVaCreatePopupShell("PickPad", noticeShellWidgetClass,
		keytextw,
		XtNvPad, 10,
		XtNstring, buffer,
		NULL);
	XtAddCallback(pick, XtNpopdownCallback, PickPopDownCB, NULL);
	XtVaGetValues(pick, XtNcontrolArea, &control, NULL);
	XtVaCreateManagedWidget("None", oblongButtonWidgetClass,
		control,
		XtNdefault, TRUE,
		NULL);
	for (p = Sentinel.back; ISPAD(p); p = p->back) {
		if (!p->haswindow)
			continue;
		XtVaSetValues(p->pane, XtNbusy, TRUE, NULL);
		padtype = padnametoresource(p->sentinel.text);
		if (strcmp(padtype, "process"))
			continue;
		w = XtVaCreateManagedWidget(p->name, oblongButtonWidgetClass,
			control, NULL);
		XtAddCallback(w, XtNselect, PickSelectCB, (XtPointer)p);
	}
	XtPopup(pick, XtGrabExclusive);
}
